﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Spark;
using Spark.Packets;

namespace Dizplay_Cruise
{
    public partial class Form1 : Form
    {
        delegate void ControlTextCallback(Control textBox, string text);
        delegate void ControlItemsAddCallback(Control textBox, object item);
        public static InSim InSim = new InSim();
        public static List<clsHistory> History = new List<clsHistory>();

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            //Drago
            //IP : 85.91.150.169
            //Port : 29008
            //Pass : dizplayprjosc
            InSim.Bind<IS_MSO>(Received_MSO);
            InSim.Bind<IS_NCN>(Received_NCN);
            InSim.Bind<IS_ISM>(Received_ISM);
            InSim.Bind<IS_CNL>(Received_CNL);

            Processor.HistoryAdd("", "");
            InSim.Connect("localhost", 29999);
            InSim.Send(new IS_ISI { IName = "^1Dizplay", Admin = "adminpass", Prefix = '!', Zero = 0, Interval = 500 });

            InSim.Send(new IS_TINY { SubT = TinyType.TINY_NCN, ReqI = 255 });
            comboBox1.Items.Clear();
            comboBox1.Items.Add(Globals.StartupFileFolderCheck());
        }

        private void controlText(Control control, string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (control.InvokeRequired)
            {
                ControlTextCallback d = new ControlTextCallback(controlText);
                this.Invoke(d, new object[] { control, text });
            }
            else
            {
                control.Text = text;
            }
        }

        private void controlItemsAdd(Control control, object item)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (control.InvokeRequired)
            {
                ControlItemsAddCallback d = new ControlItemsAddCallback(controlItemsAdd);
                this.Invoke(d, new object[] { control, item });
            }
            else
            {
                if (control is ComboBox)
                {
                    ComboBox coControl = control as ComboBox;
                    coControl.Items.Add(item);
                }
                else if (control is ListBox)
                {
                    ListBox coControl = control as ListBox;
                    coControl.Items.Add(item);
                }
            }
        }

        private void comboBox1_Clicked(object sender, EventArgs e)
        {
            int currSelIdx = comboBox1.SelectedIndex;
            comboBox1.Items.Clear();

            foreach (clsHistory H in History)
            {
                comboBox1.Items.Add(H.Title);
            }
            comboBox1.SelectedIndex = currSelIdx;
        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedItem.ToString() != "")
            {
                Helpers.ItObj selItem = comboBox1.SelectedItem as Helpers.ItObj;
                textBox1.Text = History[selItem.Value].Text;
            }
            else
            {
                textBox1.Text = "";
            }
        }

        private void textBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == 13 && textBox2.Text != "")
            {
                InSim.Send(textBox2.Text);
                textBox2.Text = "";
                textBox2.Focus();
            }
        }

        private void Received_MSO(IS_MSO MSO)
        {
            if (textBox3.Text != "")
            {
                //ASO = AutoScrollOffset
                Point ASO = textBox3.AutoScrollOffset;
                

                controlText(textBox3, Processor.StripLFSTags(MSO.Msg + Globals.nl + textBox3.Text));
            }
            else
            {
                controlText(textBox3, Processor.StripLFSTags(MSO.Msg));
            }
        }

        private void Received_NCN(IS_NCN NCN)
        {
            controlItemsAdd(comboBox2, new Helpers.ItObj(NCN.UName, int.Parse(NCN.UCID.ToString())));
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 20, 50, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 21, 50, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 22, 55, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 23, 55, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 24, 60, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 25, 60, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 26, 65, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 27, 65, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 28, 70, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 29, 70, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 30, 75, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 31, 75, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 32, 80, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 33, 80, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 34, 85, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 35, 85, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 36, 90, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 37, 90, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 38, 95, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 39, 95, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 40, 100, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C1, 41, 100, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 20, 50, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 21, 50, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 22, 55, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 23, 55, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 24, 60, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 25, 60, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 26, 65, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 27, 65, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 28, 70, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 29, 70, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 30, 75, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 31, 75, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 32, 80, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 33, 80, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 34, 85, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 35, 85, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 36, 90, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 37, 90, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 38, 95, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 39, 95, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 40, 100, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C2, 41, 100, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 20, 50, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 21, 50, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 22, 55, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 23, 55, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 24, 60, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 25, 60, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 26, 65, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 27, 65, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 28, 70, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 29, 70, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 30, 75, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 31, 75, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 32, 80, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 33, 80, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 34, 85, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 35, 85, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 36, 90, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 37, 90, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 38, 95, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 39, 95, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 40, 100, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | ButtonStyles.ISB_C4, 41, 100, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)8, 20, 50, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)8, 21, 50, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)8, 22, 55, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)8, 23, 55, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)7, 24, 60, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)7, 25, 60, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)7, 26, 65, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)7, 27, 65, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)6, 28, 70, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)6, 29, 70, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)6, 30, 75, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)6, 31, 75, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)5, 32, 80, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)5, 33, 80, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)5, 34, 85, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)5, 35, 85, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)4, 36, 90, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)4, 37, 90, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)4, 38, 95, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)4, 39, 95, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)3, 40, 100, 50, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
            Processor.QueueButton(ButtonStyles.ISB_CLICK | ButtonStyles.ISB_LIGHT | (ButtonStyles)3, 41, 100, 80, 5, 28, 21, "Dizplay", 0, 128, NCN.UCID);
        }

        private void Received_ISM(IS_ISM ISM)
        {
            richTextBox1.Text = Processor.StripLFSTags(ISM.HName);
        }

        private void Received_CNL(IS_CNL CNL)
        {
            comboBox2.Items.Remove(CNL.UCID);
        }
    }
}
